/*
 * Decompiled with CFR 0.152.
 */
package com.plasticscm.parser.java;

import com.plasticscm.parser.java.ParsingError;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

public class ErrorWriter {
    private final String LINE_FORMAT = "%s\n";
    private BufferedWriter mWriter;
    private String mPath;

    public ErrorWriter(String path) {
        this.mPath = path;
    }

    public void writeErrors(List<ParsingError> parsingErrorList) throws IOException {
        this.mWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.mPath), "UTF-8"));
        try {
            int i = 0;
            while (i < parsingErrorList.size()) {
                this.writeParsingError(parsingErrorList.get(i));
                ++i;
            }
        }
        finally {
            this.mWriter.close();
        }
    }

    private void writeParsingError(ParsingError error) throws IOException {
        String line = String.format("%s\n", error.getDescription());
        this.mWriter.write(line);
    }
}

