/*
 * Decompiled with CFR 0.152.
 */
package com.plasticscm.parser.java;

import com.plasticscm.inputprocessor.IFileProcessor;
import com.plasticscm.parser.java.ErrorWriter;
import com.plasticscm.parser.java.FileContainerNode;
import com.plasticscm.parser.java.Parser;
import com.plasticscm.parser.java.PlasticVisitor;
import com.plasticscm.parser.java.TreeWriter;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class FileProcessor
implements IFileProcessor {
    private String mInputFilePath;
    private String mInputFileEncoding;
    private String mOutputFilePath;
    private String mErrorFilePath;

    public void setFilesInfo(String inputFilePath, String inputFileEncoding, String outputFilePath) {
        this.mInputFilePath = inputFilePath;
        this.mInputFileEncoding = inputFileEncoding;
        this.mOutputFilePath = outputFilePath;
        this.mErrorFilePath = this.buildErrorFilePath(outputFilePath);
    }

    public boolean process() {
        FileContainerNode tree;
        block5: {
            Parser parser;
            block4: {
                try {
                    parser = new Parser(this.mInputFilePath, this.mInputFileEncoding);
                    if (parser.getCode() != null) break block4;
                    return false;
                }
                catch (Exception e) {
                    System.err.println(e.getMessage());
                    e.printStackTrace();
                    return false;
                }
            }
            CompilationUnit compilationUnit = parser.parse();
            PlasticVisitor visitor = new PlasticVisitor(parser.getCode());
            compilationUnit.accept((ASTVisitor)visitor);
            tree = visitor.getTree();
            TreeWriter treeWriter = new TreeWriter(this.mOutputFilePath);
            treeWriter.writeTree(tree);
            if (tree.hasParsingErrors()) break block5;
            return true;
        }
        ErrorWriter errorWriter = new ErrorWriter(this.mErrorFilePath);
        errorWriter.writeErrors(tree.getParsingErrors());
        return true;
    }

    private String buildErrorFilePath(String outputFilePath) {
        return String.valueOf(outputFilePath) + ".error";
    }
}

