/*
 * Decompiled with CFR 0.152.
 */
package com.plasticscm.parser.java;

import com.plasticscm.parser.java.FormalParameter;
import com.plasticscm.parser.java.LocationSpan;
import com.plasticscm.parser.java.TreeNode;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MethodTreeNode
extends TreeNode {
    private final String METHOD_NODE_FORMAT = " | [%s] | [%s]";
    private String mReturnType;
    private List<FormalParameter> mFormalParameterList;

    public MethodTreeNode(TreeNode.NodeTypes nodeType, String identifier, List<String> modifierList, LocationSpan locationSpan, int startOffSet, int endOffSet, String returnType, List<FormalParameter> formalParameterList) {
        super(nodeType, identifier, modifierList, locationSpan, startOffSet, endOffSet);
        this.mReturnType = returnType;
        this.mFormalParameterList = formalParameterList;
    }

    @Override
    public String getDescription() {
        return String.valueOf(super.getDescription()) + String.format(" | [%s] | [%s]", this.mReturnType, this.getFormalParameterListStr());
    }

    private String getFormalParameterListStr() {
        if (this.mFormalParameterList.size() == 0) {
            return "";
        }
        return String.format("%s", StringUtils.join(this.mFormalParameterList, (char)';'));
    }
}

