/*
 * Decompiled with CFR 0.152.
 */
package com.plasticscm.parser.java;

import com.plasticscm.parser.java.ContainerNode;
import com.plasticscm.parser.java.FieldTreeNode;
import com.plasticscm.parser.java.FileContainerNode;
import com.plasticscm.parser.java.FormalParameter;
import com.plasticscm.parser.java.LocationSpan;
import com.plasticscm.parser.java.MethodTreeNode;
import com.plasticscm.parser.java.ParsingError;
import com.plasticscm.parser.java.TreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class PlasticVisitor
extends ASTVisitor {
    private static final String SEPARATOR = ",";
    private String mOriginalCode;
    private CompilationUnit mCompilationUnit;
    private int mPreviousNodeEnd;
    private Stack<Integer> mPreviousNodeEndStack;
    private FileContainerNode mTree;
    private ContainerNode mCurrentParent;
    private Stack<ContainerNode> mCurrentParentStack;

    public PlasticVisitor(String originalCode) {
        super(true);
        this.mOriginalCode = originalCode;
    }

    public boolean visit(CompilationUnit node) {
        this.mCompilationUnit = node;
        int endTextEndOffSet = this.mOriginalCode.length() - 1;
        this.mTree = new FileContainerNode(TreeNode.NodeTypes.FILE, null, null, this.getLocationSpan(0, endTextEndOffSet), 0, -1, 0, endTextEndOffSet, this.obtainParsingErrors());
        this.mCurrentParent = this.mTree;
        this.mCurrentParentStack = new Stack();
        this.mPreviousNodeEndStack = new Stack();
        this.mPreviousNodeEnd = -1;
        return true;
    }

    public void endVisit(CompilationUnit node) {
        this.mTree.setEndTextStartOffSet(this.mPreviousNodeEnd + 1);
    }

    public boolean visit(TypeDeclaration node) {
        if (this.needFixEndOffSetOfParent((ASTNode)node)) {
            this.fixEndOffSetOfParent();
        }
        int nodeStartPosition = this.mPreviousNodeEnd + 1;
        int nodeEndPosition = this.getNodeEndPosition((ASTNode)node);
        int openBraceOffSet = this.getOpenBraceTokenPosition(this.mOriginalCode, node.getStartPosition());
        int closeBraceOffSet = this.getCloseBraceTokenPosition(this.mOriginalCode, nodeEndPosition);
        int closeBraceEndOffSet = nodeEndPosition;
        TreeNode.NodeTypes nodeType = node.isInterface() ? TreeNode.NodeTypes.INTERFACE : TreeNode.NodeTypes.CLASS;
        List<String> modifierList = this.obtainModifiers((BodyDeclaration)node);
        LocationSpan locationSpan = this.getLocationSpan(nodeStartPosition, closeBraceEndOffSet);
        ContainerNode treeNode = new ContainerNode(nodeType, node.getName().toString(), modifierList, locationSpan, nodeStartPosition, openBraceOffSet, closeBraceOffSet, closeBraceEndOffSet);
        this.mCurrentParent.addChild(treeNode);
        this.mPreviousNodeEndStack.push(closeBraceEndOffSet);
        this.mCurrentParentStack.push(this.mCurrentParent);
        this.mPreviousNodeEnd = openBraceOffSet;
        this.mCurrentParent = treeNode;
        return true;
    }

    public void endVisit(TypeDeclaration node) {
        this.mCurrentParent.setEndTextStartOffSet(this.mPreviousNodeEnd + 1);
        this.mPreviousNodeEnd = this.mPreviousNodeEndStack.pop();
        this.mCurrentParent = this.mCurrentParentStack.pop();
    }

    public boolean visit(PackageDeclaration node) {
        String name = node.getName().toString();
        return this.doVisitSimpleNode((ASTNode)node, TreeNode.NodeTypes.PACKAGE, name);
    }

    public boolean visit(ImportDeclaration node) {
        String name = node.getName().toString();
        name = String.valueOf(name) + (node.isOnDemand() ? ".*" : "");
        return this.doVisitSimpleNode((ASTNode)node, TreeNode.NodeTypes.IMPORT, name);
    }

    public boolean visit(EnumDeclaration node) {
        String name = node.getName().toString();
        return this.doVisitSimpleNode((ASTNode)node, TreeNode.NodeTypes.ENUM, name);
    }

    public boolean visit(FieldDeclaration node) {
        String name = this.getFieldIdentifier(node);
        return this.doVisitSimpleNode((ASTNode)node, TreeNode.NodeTypes.FIELD, name);
    }

    public boolean visit(MethodDeclaration node) {
        String name = node.getName().toString();
        return this.doVisitSimpleNode((ASTNode)node, TreeNode.NodeTypes.METHOD, name);
    }

    public FileContainerNode getTree() {
        return this.mTree;
    }

    private List<ParsingError> obtainParsingErrors() {
        IProblem[] problems = this.mCompilationUnit.getProblems();
        ArrayList<ParsingError> parsingErrorList = new ArrayList<ParsingError>();
        if (problems.length == 0) {
            return parsingErrorList;
        }
        int index = 0;
        while (index < problems.length) {
            IProblem problem = problems[index];
            if (problem.isError()) {
                parsingErrorList.add(this.BuildParsingError(problem));
            }
            ++index;
        }
        return parsingErrorList;
    }

    private ParsingError BuildParsingError(IProblem problem) {
        int row = this.mCompilationUnit.getLineNumber(problem.getSourceStart());
        int column = this.mCompilationUnit.getColumnNumber(problem.getSourceEnd());
        return new ParsingError(row, column, problem.getMessage());
    }

    private boolean doVisitSimpleNode(ASTNode node, TreeNode.NodeTypes type, String name) {
        if (this.needFixEndOffSetOfParent(node)) {
            this.fixEndOffSetOfParent();
        }
        int nodeStartPosition = this.mPreviousNodeEnd + 1;
        int nodeEndPosition = this.getNodeEndPosition(node);
        List<String> modifierList = node instanceof BodyDeclaration ? this.obtainModifiers((BodyDeclaration)node) : null;
        LocationSpan locationSpan = this.getLocationSpan(nodeStartPosition, nodeEndPosition);
        TreeNode treeNode = this.BuildTreeNode(node, type, name, modifierList, locationSpan, nodeStartPosition, nodeEndPosition);
        this.mCurrentParent.addChild(treeNode);
        this.mPreviousNodeEnd = nodeEndPosition;
        return false;
    }

    private TreeNode BuildTreeNode(ASTNode node, TreeNode.NodeTypes nodeType, String name, List<String> modifierList, LocationSpan locationSpan, int nodeStartPosition, int nodeEndPosition) {
        boolean isFieldDeclaration = node instanceof FieldDeclaration;
        if (isFieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
            String type = fieldDeclaration.getType().toString();
            return new FieldTreeNode(nodeType, name, modifierList, locationSpan, nodeStartPosition, nodeEndPosition, type);
        }
        boolean isMethodDeclaration = node instanceof MethodDeclaration;
        if (!isMethodDeclaration) {
            return new TreeNode(nodeType, name, modifierList, locationSpan, nodeStartPosition, nodeEndPosition);
        }
        MethodDeclaration methodDeclaration = (MethodDeclaration)node;
        Type returnType = methodDeclaration.getReturnType2();
        return new MethodTreeNode(nodeType, name, modifierList, locationSpan, nodeStartPosition, nodeEndPosition, returnType != null ? returnType.toString() : null, this.obtainFormalParameters(methodDeclaration));
    }

    private boolean needFixEndOffSetOfParent(ASTNode node) {
        if (this.mCurrentParent instanceof FileContainerNode) {
            return false;
        }
        if (this.mCurrentParent.getChildrenCount() > 0) {
            return false;
        }
        int parentLine = this.mCompilationUnit.getLineNumber(this.mPreviousNodeEnd);
        int nodeLine = this.mCompilationUnit.getLineNumber(node.getStartPosition());
        return nodeLine != parentLine;
    }

    private void fixEndOffSetOfParent() {
        int endOffSet = this.getFixedEndOffSetOfParent();
        this.mCurrentParent.setEndOffSet(endOffSet);
        this.mPreviousNodeEnd = endOffSet;
    }

    private int getFixedEndOffSetOfParent() {
        int current = 32;
        int endOffSet = this.mPreviousNodeEnd;
        while (endOffSet < this.mOriginalCode.length()) {
            current = this.mOriginalCode.charAt(endOffSet);
            if (current == 13 || current == 10) break;
            ++endOffSet;
        }
        if (endOffSet == this.mOriginalCode.length()) {
            return endOffSet;
        }
        String str = this.mOriginalCode.substring(endOffSet);
        if (str.startsWith("\r\n")) {
            return ++endOffSet;
        }
        return endOffSet;
    }

    private int getNodeEndPosition(ASTNode node) {
        int endPosition = this.mCompilationUnit.getExtendedStartPosition(node) + this.mCompilationUnit.getExtendedLength(node);
        String str = this.mOriginalCode.substring(endPosition);
        if (str.startsWith("\r\n")) {
            return ++endPosition;
        }
        if (str.startsWith("\n") || str.startsWith("\r")) {
            return endPosition;
        }
        return --endPosition;
    }

    private List<String> obtainModifiers(BodyDeclaration node) {
        List extendedModifierList = node.modifiers();
        ArrayList<String> modifierList = new ArrayList<String>();
        if (extendedModifierList.size() == 0) {
            return modifierList;
        }
        for (IExtendedModifier extendedModifier : extendedModifierList) {
            if (!extendedModifier.isModifier()) continue;
            modifierList.add(extendedModifier.toString());
        }
        return modifierList;
    }

    private LocationSpan getLocationSpan(int beginPosition, int EndPosition) {
        int startLine = this.mCompilationUnit.getLineNumber(beginPosition);
        int startColumn = this.mCompilationUnit.getColumnNumber(beginPosition);
        int endLine = this.mCompilationUnit.getLineNumber(EndPosition);
        int endColumn = this.mCompilationUnit.getColumnNumber(EndPosition);
        return new LocationSpan(startLine, startColumn, endLine, endColumn);
    }

    private int getOpenBraceTokenPosition(String originalCode, int nodeStartPosition) {
        return originalCode.indexOf(123, nodeStartPosition);
    }

    private int getCloseBraceTokenPosition(String originalCode, int nodeEndPosition) {
        return originalCode.lastIndexOf(125, nodeEndPosition);
    }

    private List<FormalParameter> obtainFormalParameters(MethodDeclaration node) {
        List variableList = node.parameters();
        ArrayList<FormalParameter> formalParameterList = new ArrayList<FormalParameter>();
        if (variableList.size() == 0) {
            return formalParameterList;
        }
        for (SingleVariableDeclaration variable : variableList) {
            formalParameterList.add(this.BuildFormalParameter(variable));
        }
        return formalParameterList;
    }

    private FormalParameter BuildFormalParameter(SingleVariableDeclaration variable) {
        String name = variable.getName().toString();
        String type = variable.getType().toString();
        return new FormalParameter(name, type);
    }

    private String getFieldIdentifier(FieldDeclaration node) {
        List fragments = node.fragments();
        if (fragments.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(fragments.size());
        for (VariableDeclarationFragment var : fragments) {
            sb.append(String.valueOf(var.getName().toString()) + SEPARATOR);
        }
        sb.delete(sb.length() - SEPARATOR.length(), sb.length());
        return sb.toString();
    }
}

