/*
 * Decompiled with CFR 0.152.
 */
package com.plasticscm.parser.java;

import com.plasticscm.parser.java.LocationSpan;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TreeNode {
    private final String NODE_FORMAT = "%s | %s | %s | %s | [%d,%d]";
    private NodeTypes mNodeType;
    private String mIdentifier;
    private List<String> mModifierList;
    private LocationSpan mLocationSpan;
    private int mStartOffSet;
    protected int mEndOffset;
    private ArrayList<TreeNode> mChildren;

    public TreeNode(NodeTypes nodeType, String identifier, List<String> modifierList, LocationSpan locationSpan, int startOffSet, int endOffSet) {
        this.mNodeType = nodeType;
        this.mIdentifier = identifier;
        this.mModifierList = modifierList;
        this.mLocationSpan = locationSpan;
        this.mStartOffSet = startOffSet;
        this.mEndOffset = endOffSet;
    }

    public void addChild(TreeNode node) {
        if (this.mChildren == null) {
            this.mChildren = new ArrayList();
        }
        this.mChildren.add(node);
    }

    public int getChildrenCount() {
        if (this.mChildren != null) {
            return this.mChildren.size();
        }
        return 0;
    }

    public TreeNode getChild(int i) {
        return this.mChildren.get(i);
    }

    public String getDescription() {
        return String.format("%s | %s | %s | %s | [%d,%d]", this.mNodeType.toString().toLowerCase(), this.mIdentifier, this.getModifierListStr(), this.mLocationSpan.getDescription(), this.mStartOffSet, this.mEndOffset);
    }

    private String getModifierListStr() {
        if (!this.HasModifiers()) {
            return "";
        }
        return String.format("[%s]", StringUtils.join(this.mModifierList, (char)','));
    }

    private boolean HasModifiers() {
        return this.mModifierList != null && this.mModifierList.size() > 0;
    }

    public static enum NodeTypes {
        FILE,
        PACKAGE,
        IMPORT,
        INTERFACE,
        CLASS,
        ENUM,
        FIELD,
        METHOD;

    }
}

