/*
 * Decompiled with CFR 0.152.
 */
package com.plasticscm.parser.java;

import com.plasticscm.parser.java.ContainerNode;
import com.plasticscm.parser.java.TreeNode;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.lang.StringUtils;

public class TreeWriter {
    private final String IDENT_STR = "\t";
    private final String LINE_FORMAT = "%s%s\n";
    private BufferedWriter mWriter;
    private String mPath;

    public TreeWriter(String path) {
        this.mPath = path;
    }

    public void writeTree(ContainerNode node) throws IOException {
        this.mWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.mPath), "UTF-8"));
        try {
            this.writeNode(node, 0);
        }
        finally {
            this.mWriter.close();
        }
    }

    private void writeNode(TreeNode node, int level) throws IOException {
        this.writeNodeDescription(node, level);
        if (!(node instanceof ContainerNode)) {
            return;
        }
        int i = 0;
        while (i < node.getChildrenCount()) {
            TreeNode child = node.getChild(i);
            this.writeNode(child, level + 1);
            ++i;
        }
    }

    private void writeNodeDescription(TreeNode node, int level) throws IOException {
        String line = String.format("%s%s\n", StringUtils.repeat((String)"\t", (int)level), node.getDescription());
        this.mWriter.write(line);
    }
}

